@ECHO off
SETLOCAL
setlocal enabledelayedexpansion

SET MAJVER=1
SET MINVER=0

REM ADMIN PRIVILEGES
net session >nul 2>&1
if NOT %ERRORLEVEL% EQU 0 (
	echo Failed: Administrator privileges required for diagnosing Chroma SDK. Please restart with admin rights.
	exit /b 1
)

REM SET UP DIAGNOSTIC FOLDER
mkdir "%~dp0\ChromaSDKDiagnosticTool"
SET OUTPUT_FILE_DIERECTORY=%~dp0\ChromaSDKDiagnosticTool

REM SET UP LOG FILE
for /f %%i in ('hostname') do set HOSTNAME=%%i
For /f "tokens=2-4 delims=/ " %%a in ('date /t') do (set CURDATE=%%c%%a%%b)
For /f "tokens=1-2 delims=/:" %%a in ("%TIME%") do (set CURTIME=%%a%%b)
SET LOGFILENAME="%OUTPUT_FILE_DIERECTORY%\ChromaSDKDiagnosis_%CURDATE%_%CURTIME%.log"
@echo Chroma SDK diagnosis for %HOSTNAME% > %LOGFILENAME%
@echo Diagnostic Tool Version: %MAJVER%.%MINVER% >> %LOGFILENAME%
@echo. >> %LOGFILENAME%

REM FIND CHROMA SDK FOLDER
SET SDK_FOLDER=%ProgramFiles%\Razer Chroma SDK
if exist "%ProgramFiles(x86)%" SET SDK_FOLDER=%ProgramFiles(x86)%\Razer Chroma SDK

REM FIND BROADCAST SDK FOLDER
SET BROADCASTSDK_FOLDER=%ProgramFiles%\Razer\ChromaBroadcast
if exist "%ProgramFiles(x86)%" SET BROADCASTSDK_FOLDER=%ProgramFiles(x86)%\Razer\ChromaBroadcast

echo ===================================================================
echo                 Razer Chroma SDK Diagnostic Tool
echo ===================================================================

@echo ===================================================================  >> %LOGFILENAME%
@echo                 	    Chroma SDK Status		    				   >> %LOGFILENAME%
@echo ===================================================================  >> %LOGFILENAME%
@echo PATH: %PATH% >> %LOGFILENAME%
echo.
echo Retrieving Chroma SDK Status
sc query "Razer Chroma SDK Service" >> %LOGFILENAME%
sc query "Razer Chroma SDK Server" >> %LOGFILENAME%

echo.
echo Getting Connected Devices
wmic path CIM_LogicalDevice where ^"Description like 'USB%%'^" get /value > "%OUTPUT_FILE_DIERECTORY%\ConnectedDevices.txt"

@echo ===================================================================  >> %LOGFILENAME%
@echo                 	  SDK Service CPU Usage	    				       >> %LOGFILENAME%
@echo ===================================================================  >> %LOGFILENAME%
echo.
echo Analysing Chroma SDK Service CPU usage
typeperf ^"\Process(RzSDKService)\%% User Time^" -sc 5 >> %LOGFILENAME%

@echo ===================================================================  >> %LOGFILENAME%
@echo                 	  SDK Server CPU Usage	    				       >> %LOGFILENAME%
@echo ===================================================================  >> %LOGFILENAME%
echo.
echo Analysing Chroma SDK Server CPU usage
typeperf ^"\Process(RzSDKServer)\%% User Time^" -sc 5 >> %LOGFILENAME%

@echo ===================================================================  >> %LOGFILENAME%
@echo                 	 Certificate Information    					   >> %LOGFILENAME%
@echo ===================================================================  >> %LOGFILENAME%
echo.
echo Retrieving Chroma SDK certificate information
certutil -store ROOT "Razer Chroma SDK" >> %LOGFILENAME%
@echo. >> %LOGFILENAME%
certutil -store MY "Razer Chroma SDK" >> %LOGFILENAME%
@echo. >> %LOGFILENAME%
netsh http show sslcert ipport=0.0.0.0:54236 >> %LOGFILENAME%

rem @echo ===================================================================  >> %LOGFILENAME%
rem @echo                     Chroma SDK Registry   						   >> %LOGFILENAME%
rem @echo ===================================================================  >> %LOGFILENAME%
echo.
echo Exporting Chroma SDK registry
SET REGISTRY_LOCATION=HKEY_LOCAL_MACHINE\Software
if exist "%ProgramFiles(x86)%" SET REGISTRY_LOCATION=HKEY_LOCAL_MACHINE\Software\WOW6432Node
regedit /e "%OUTPUT_FILE_DIERECTORY%\chromasdk.reg" "%REGISTRY_LOCATION%\Razer Chroma SDK"
regedit /e "%OUTPUT_FILE_DIERECTORY%\sdkservice.reg" "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\\Services\\Razer Chroma SDK Service"
regedit /e "%OUTPUT_FILE_DIERECTORY%\sdkserver.reg" "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\\Services\\Razer Chroma SDK Server"
rem more chromasdk.reg >> %LOGFILENAME%
rem del chromasdk.reg

echo.
echo Exporting Broadcast SDK registry
rem @echo ===================================================================  >> %LOGFILENAME%
rem @echo                     Broadcast SDK Registry    					   >> %LOGFILENAME%
rem @echo ===================================================================  >> %LOGFILENAME%
regedit /e "%OUTPUT_FILE_DIERECTORY%\broadcastsdk.reg" "%REGISTRY_LOCATION%\Razer\ChromaBroadcast"
rem more broadcastsdk.reg >> %LOGFILENAME%
rem del broadcastsdk.reg


@echo ===================================================================  >> %LOGFILENAME%
@echo                      Chroma SDK Files 		  					   >> %LOGFILENAME%
@echo ===================================================================  >> %LOGFILENAME%
echo.
echo Retrieving Chroma SDK file information

xcopy "%SDK_FOLDER%\Devices.xml" "%OUTPUT_FILE_DIERECTORY%\." /y /a >NUL
xcopy "%LOCALAPPDATA%\Razer\Chroma SDK\CrashDumps" "%OUTPUT_FILE_DIERECTORY%\." /y /a /s >NUL

@echo ---- EXE ---- >> %LOGFILENAME%
FOR %%I in ("%SDK_FOLDER%\bin\*.exe") DO (
@echo %%I >> %LOGFILENAME%
)
@echo ---- DLL ---- >> %LOGFILENAME%
FOR %%I in ("%SDK_FOLDER%\bin\*.dll") DO (
@echo %%I >> %LOGFILENAME%
)
@echo ---- MOD ---- >> %LOGFILENAME%
FOR %%I in ("%SDK_FOLDER%\bin\*.mod") DO (
@echo %%I >> %LOGFILENAME%
)
@echo ---- DAT ---- >> %LOGFILENAME%
FOR %%I in ("%SDK_FOLDER%\bin\*.dat") DO (
@echo %%I >> %LOGFILENAME%
)
@echo ---- Apps --- >> %LOGFILENAME%
FOR %%I in ("%ProgramData%\Razer Chroma SDK\Apps\*.*") DO (
@echo %%I >> %LOGFILENAME%
)

echo.
echo Retrieving Broadcast SDK file information
@echo ===================================================================  >> %LOGFILENAME%
@echo                      Broadcast SDK Files 		  					   >> %LOGFILENAME%
@echo ===================================================================  >> %LOGFILENAME%
xcopy "%BROADCASTSDK_FOLDER%\broadcast.dat" "%OUTPUT_FILE_DIERECTORY%\." /y /a >NUL
xcopy "%BROADCASTSDK_FOLDER%\install.log" "%OUTPUT_FILE_DIERECTORY%\." /y /a >NUL
@echo ---- DLL ---- >> %LOGFILENAME%
FOR %%I in ("%BROADCASTSDK_FOLDER%\bin\*.dll") DO (
@echo %%I >> %LOGFILENAME%
)

echo.
echo Diagnosis complete

ENDLOCAL