@ECHO off
SETLOCAL

REM DO NOT CHANGE THESE
SET THX_LOG_PROVIDER={094B0643-10F9-44BC-8526-856D1DD7B670}
SET THX_LOGGER_NAME=THXTraceLog

REM CHANGE THIS IF NEEDED
rem SET OUTPUT_FILE_PATH=C:\%THX_LOGGER_NAME.etl
SET OUTPUT_FILE_BASE_NAME=THXLogs
SET OUTPUT_FILE_DIRECTORY=%~dp0
SET OUTPUT_FILE_PATH="%OUTPUT_FILE_DIRECTORY%%OUTPUT_FILE_BASE_NAME%.etl"

REM ---------------------------------------------------------------------------
REM	ENSURE THAT WE HAVE ADMIN PREIVILEGES 
REM ---------------------------------------------------------------------------
net session >nul 2>&1
if NOT %ERRORLEVEL% EQU 0 (
    echo Failed: Administrator privileges required for collecting logs. Please restart with admin rights.
    exit /b 1
)

REM ---------------------------------------------------------------------------
REM VERIFY THAT LOGMAN.exe EXISTS
REM ---------------------------------------------------------------------------
if not exist "C:\windows\system32\logman.exe" (
	echo Failed: "C:\windows\system32\logman.exe" does not exist
	exit /b 1
)

REM ---------------------------------------------------------------------------
REM DELETE ANY EXISTING LOGGING SESSIONS
REM ---------------------------------------------------------------------------
REM note that there is no convenient way to check if a session exists from here
logman stop %THX_LOGGER_NAME% > NUL 2>&1
logman delete %THX_LOGGER_NAME% > NUL 2>&1

REM ---------------------------------------------------------------------------
REM CREATE THE LOGGING CONSUMER AND START LOGGING
REM ---------------------------------------------------------------------------
logman create trace %THX_LOGGER_NAME% -ow -o %OUTPUT_FILE_PATH% -p %THX_LOG_PROVIDER% > NUL 2>&1
if not errorlevel == 0 (
	echo Error occured. Unable to create consumer
	exit /b 1
)

logman start %THX_LOGGER_NAME% > NUL 2>&1
if not errorlevel == 0 (
	echo Error occured. Unable to start logging session
	exit /b 1
)

echo ===================================================================
ECHO                     Razer THX Log Collector
echo ===================================================================
echo.
ECHO Started collecting logs...
ECHO Reproduce your issue. Once done, enter any key to stop collecting logs.
echo.

REM ---------------------------------------------------------------------------
REM WAIT FOR ANY KEY TO BE PRESSED
REM ---------------------------------------------------------------------------
pause > NUL


REM ---------------------------------------------------------------------------
REM STOP LOGGING AND DELETE THE LOGGING CONSUMER
REM ---------------------------------------------------------------------------
logman stop %THX_LOGGER_NAME% > NUL 2>&1
if not errorlevel == 0 (
	echo Error occured. Unable to stop logging session
	exit /b 1
)
logman delete %THX_LOGGER_NAME% > NUL 2>&1
if not errorlevel == 0 (
	echo Error occured. Unable to delete consumer
	exit /b 1
)

echo.
echo Note: There may be a _000001 (or similar) appended to the above specified file name
echo       It is recommended to copy all log files starting with '%OUTPUT_FILE_BASE_NAME%'
echo.
echo Logs have been captured and saved successfully in the directory: 
echo %OUTPUT_FILE_DIRECTORY%

pause

ENDLOCAL